/*
 * Decompiled with CFR 0.152.
 */
package alabaster.crabbersdelight.data;

import alabaster.crabbersdelight.common.registry.ModItems;
import alabaster.crabbersdelight.common.utils.TextUtil;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.advancements.AdvancementProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Advancements
extends AdvancementProvider {
    private final Path PATH;
    public static final Logger LOGGER = LogManager.getLogger();

    public Advancements(DataGenerator generatorIn) {
        super(generatorIn);
        this.PATH = generatorIn.m_123916_();
    }

    public void m_213708_(CachedOutput cache) {
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.m_138327_())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.m_138327_());
            }
            Path path1 = Advancements.getPath(this.PATH, advancement);
            try {
                DataProvider.m_236072_((CachedOutput)cache, (JsonElement)advancement.m_138313_().m_138400_(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        new CrabbersDelightAdvancements().accept(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.m_138327_().m_135827_() + "/advancements/" + advancementIn.m_138327_().m_135815_() + ".json");
    }

    public static class CrabbersDelightAdvancements
    implements Consumer<Consumer<Advancement>> {
        @Override
        public void accept(Consumer<Advancement> consumer) {
            Advancement crabbersDelight = Advancement.Builder.m_138353_().m_138371_((ItemLike)ModItems.RAW_CLAWSTER.get(), (Component)TextUtil.getTranslation("advancement.root", new Object[0]), (Component)TextUtil.getTranslation("advancement.root.desc", new Object[0]), new ResourceLocation("minecraft:textures/block/sand.png"), FrameType.TASK, false, false, false).m_138386_("seeds", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[0])).m_138389_(consumer, this.getNameId("main/root"));
            Advancement itsATrap = CrabbersDelightAdvancements.getAdvancement(crabbersDelight, (ItemLike)ModItems.CRAB_TRAP.get(), "craft_crab_trap", FrameType.TASK, true, true, false).m_138386_("crab_trap", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.CRAB_TRAP.get()})).m_138389_(consumer, this.getNameId("main/craft_crab_trap"));
            Advancement crustaceanCookingStation = CrabbersDelightAdvancements.getAdvancement(itsATrap, (ItemLike)ModItems.RAW_CRAB.get(), "cook_crustaceans", FrameType.TASK, true, false, false).m_138386_("crab", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_CRAB.get()})).m_138386_("shrimp", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_SHRIMP.get()})).m_138386_("clawster", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.COOKED_CLAWSTER.get()})).m_138360_(RequirementsStrategy.f_15979_).m_138389_(consumer, this.getNameId("main/cook_crustaceans"));
            Advancement motherOfPearl = CrabbersDelightAdvancements.getAdvancement(itsATrap, (ItemLike)ModItems.CLAM.get(), "get_pearl", FrameType.TASK, true, false, false).m_138386_("pearl", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)ModItems.PEARL.get()})).m_138389_(consumer, this.getNameId("main/get_pearl"));
        }

        protected static Advancement.Builder getAdvancement(Advancement parent, ItemLike display, String name, FrameType frame, boolean showToast, boolean announceToChat, boolean hidden) {
            return Advancement.Builder.m_138353_().m_138398_(parent).m_138371_(display, (Component)TextUtil.getTranslation("advancement." + name, new Object[0]), (Component)TextUtil.getTranslation("advancement." + name + ".desc", new Object[0]), null, frame, showToast, announceToChat, hidden);
        }

        private String getNameId(String id) {
            return "crabbersdelight:" + id;
        }
    }
}

